<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
<script type="text/javascript" src="https://js.stripe.com/v3/"></script>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<meta name="locale" content="<?php echo e(app()->getLocale()); ?>">
<meta name="content-language" content="<?php echo e(app()->getLocale()); ?>">
<title><?php echo e($settings->site_name); ?> | <?php echo e($title ?? ''); ?></title>
    

<link rel="icon" href="<?php echo e(asset($settings->favicon)); ?>" type="image/png" />
<script src="https://cdn.tailwindcss.com"></script>
<link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://unpkg.com/lucide@latest"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
<script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
    
<style>
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');
body {
    font-family: 'Inter', sans-serif;
    }
    
    .animate-float {
        animation: float 3s ease-in-out infinite;
    }
    
    @keyframes float {
        0% {
            transform: translateY(0px);
        }
        50% {
            transform: translateY(-10px);
        }
        100% {
            transform: translateY(0px);
        }
    }
    
    .animate-bounce-slow {
        animation: bounce 2s ease-in-out infinite;
    }
    
    @keyframes bounce {
        0%, 100% {
            transform: translateY(0);
        }
        50% {
            transform: translateY(-10px);
        }
    }
    
    .animate-ping-slow {
        animation: ping 2s ease-in-out infinite;
    }
    
    @keyframes ping {
        0% {
            transform: scale(1);
            opacity: 1;
        }
        50% {
            transform: scale(1.1);
            opacity: 0.8;
        }
        100% {
            transform: scale(1);
            opacity: 1;
        }
    }
</style>
    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

</head>
<body class="bg-[#0A0714] text-white w-full h-full">
    <div class="flex">
        <main class="flex-1">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            lucide.createIcons();
            
            // Add locale handling for JavaScript
            window.locale = '<?php echo e(app()->getLocale()); ?>';
            window.translations = <?php echo json_encode(__('investment'), 15, 512) ?>;
        });
    </script>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>




<?php /**PATH /home/karamelh/public_html/corepip.karamelscript.com.ng/resources/views/layouts/welcome.blade.php ENDPATH**/ ?>