<form wire:submit='changePassword' class="space-y-6">
    
    <div class="space-y-2">
        <label class="text-sm text-gray-400"><?php echo e(__('t.current_password')); ?></label>
        <input type="password" 
            wire:model='current_password'
            required
            class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
    </div>

    
    <div class="space-y-2">
        <label class="text-sm text-gray-400"><?php echo e(__('t.new_password')); ?></label>
        <input type="password" 
            wire:model='password'
            required
            class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
    </div>

    
    <div class="space-y-2">
        <label class="text-sm text-gray-400"><?php echo e(__('t.confirm_new_password')); ?></label>
        <input type="password" 
            wire:model='password_confirmation'
            required
            class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
    </div>

    
    <div class="flex justify-end">
        <button type="submit"
            class="bg-theme-primary text-black px-6 py-2.5 rounded-lg hover:bg-theme-primary-dark transition-colors flex items-center gap-2">
            <div wire:loading>
                <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
            </div>
            <span><?php echo e(__('t.change_password')); ?></span>
        </button>
    </div>
</form>



<?php /**PATH /home/karamelh/public_html/corepip.karamelscript.com.ng/resources/views/millage/account-settings/password.blade.php ENDPATH**/ ?>