<div x-data="{ open: false }" class="mt-8">
    
    <div class="flex justify-center">
        <button type="button" 
            x-on:click="open = true" 
            x-show="!open"
            class="inline-flex items-center gap-2 bg-gradient-theme-primary text-black px-8 py-3 rounded-xl hover:brightness-110 transition-all font-medium">
            <i class="fas fa-shield-alt w-5 h-5"></i>
            <?php echo e(__('t.confirm_payment')); ?>

        </button>
    </div>

    
    <div x-show="open" style="display: none">
        <form wire:submit.prevent='savePayment' class="bg-gradient-to-b from-gray-800/50 to-transparent backdrop-blur-sm rounded-xl p-6 space-y-6">
            <div class="space-y-6">
                
                <div class="text-center">
                    <h3 class="text-lg font-medium mb-2"><?php echo e(__('t.payment_verification')); ?></h3>
                    <p class="text-sm text-gray-400"><?php echo e(__('t.upload_proof_message')); ?></p>
                </div>

                
                <div class="space-y-4">
                    <div class="border-2 border-dashed border-gray-700 rounded-xl p-6 text-center hover:border-theme-primary transition-colors">
                        <input type="file" 
                            wire:model='proof'
                            required
                            class="w-full p-2 bg-gray-800 border border-gray-600 rounded text-white"
                            accept="image/*,application/pdf"
                        >
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['proof'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-400 text-sm mt-1"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        
                        
                        <!--[if BLOCK]><![endif]--><?php if($proof): ?>
                            <p class="text-green-400 text-sm mt-2">File selected: <?php echo e($proof->getClientOriginalName()); ?></p>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        
                        
                        <div wire:loading wire:target="proof" class="text-blue-400 text-sm mt-2">
                            Uploading file...
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="flex items-center justify-center md:justify-end gap-3">
                <button type="button" 
                    x-on:click="open = false"
                    class="px-6 py-2.5 rounded-lg border border-gray-700 text-gray-400 hover:text-gray-300 hover:border-gray-600 transition-colors">
                    <?php echo e(__('t.cancel')); ?>

                </button>
                <button type="submit" 
                    wire:loading.attr="disabled"
                    class="bg-theme-primary text-black px-6 py-2.5 rounded-lg hover:bg-theme-primary-dark transition-colors inline-flex items-center gap-2 disabled:opacity-50">
                    <span wire:loading.remove wire:target="savePayment"><?php echo e(__('t.complete')); ?></span>
                    <span wire:loading wire:target="savePayment"><?php echo e(__('t.processing')); ?></span>
                </button>
            </div>
        </form>
    </div>
</div>



<?php /**PATH /home/sbrbot/6figs.sbrbot.trading/resources/views/millage/deposit/includes/submit-payment.blade.php ENDPATH**/ ?>