<?php use \Illuminate\Support\Number as Number; ?>
 <?php $__env->slot('title', null, []); ?> 
    Dashboard Overview
 <?php $__env->endSlot(); ?>
 <?php $__env->slot('styles', null, []); ?> 
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
 <?php $__env->endSlot(); ?>
<div>
    <div class="mt-2 mb-4">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-lg-row">
            <div class="mt-2 mb-1">
                <h2>
                    Welcome, <span class="font-weight-bold"><?php echo e(auth()->user()->name); ?>!</span>
                </h2>
                <small class="text-muted"><?php echo e($quote); ?></small>
            </div>
            <div class="py-2 ml-md-auto py-md-0">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view deposits')): ?>
                    <a href="<?php echo e(route('admin.manageDeposits')); ?>" <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                        class="btn btn-success btn-sm">
                        <i class="bi bi-arrow-down-circle-fill"></i>
                        Deposits
                    </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view withdrawals')): ?>
                    <a href="<?php echo e(route('admin.manageWithdrawal')); ?>" <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                        class="btn btn-danger btn-sm">
                        <i class="bi bi-arrow-up-right-circle-fill"></i>
                        Withdrawals
                    </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view users')): ?>
                    <a href="<?php echo e(route('admin.users.listUsers')); ?>" <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                        class="btn btn-dark btn-sm">
                        <i class="bi bi-people-fill"></i>
                        Users
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view admin dashboard stats')): ?>
        <!-- Beginning of  Dashboard Stats  -->
        <div class="row">
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row align-items-center">
                            <div class="col-icon">
                                <div class="text-center icon-big icon-primary bubble-shadow-small">
                                    <i class="bi bi-people-fill"></i>
                                </div>
                            </div>
                            <div class="ml-3 col col-stats ml-sm-0">
                                <div class="numbers">
                                    <p class="card-category">Total users</p>
                                    <h4 class="card-title"><?php echo e(Number::abbreviate($numberOfUsers)); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-icon">
                                <div class="text-center icon-big icon-info bubble-shadow-small">
                                    <i class="bi bi-receipt"></i>
                                </div>
                            </div>
                            <div class="ml-3 col col-stats ml-sm-0">
                                <div class="numbers">
                                    <p class="card-category">Active Invesments</p>
                                    <h4 class="card-title"><?php echo e(Number::abbreviate($subscribers)); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-icon">
                                <div class="text-center icon-big icon-danger bubble-shadow-small">
                                    <i class="bi bi-arrow-up-right-circle-fill"></i>
                                </div>
                            </div>
                            <div class="ml-3 col col-stats ml-sm-0">
                                <div class="numbers">
                                    <p class="card-category">Total withdrawals</p>
                                    <h4 class="card-title">
                                        <?php echo e(Number::currency($total_withdrawn, $settings->s_currency)); ?>

                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-icon">
                                <div class="text-center icon-big icon-success bubble-shadow-small">
                                    <i class="bi bi-arrow-down-circle-fill"></i>
                                </div>
                            </div>
                            <div class="ml-3 col col-stats ml-sm-0">
                                <div class="numbers">
                                    <p class="card-category">Total deposits</p>
                                    <h4 class="card-title">
                                        <?php echo e(Number::currency($total_deposited, $settings->s_currency)); ?>

                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row align-items-center">
                            <div class="col-icon">
                                <div class="text-center icon-big icon-danger bubble-shadow-small">
                                    <i class="bi bi-person-fill-slash"></i>
                                </div>
                            </div>
                            <div class="ml-3 col col-stats ml-sm-0">
                                <div class="numbers">
                                    <p class="card-category">Blocked users</p>
                                    <h4 class="card-title"><?php echo e(Number::abbreviate($blockedusers)); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-icon">
                                <div class="text-center icon-big icon-success bubble-shadow-small">
                                    <i class="bi bi-person-check"></i>
                                </div>
                            </div>
                            <div class="ml-3 col col-stats ml-sm-0">
                                <div class="numbers">
                                    <p class="card-category">Active users</p>
                                    <h4 class="card-title"><?php echo e(Number::format($active_users)); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-icon">
                                <div class="text-center icon-big icon-warning bubble-shadow-small">
                                    <i class="flaticon-graph"></i>
                                </div>
                            </div>
                            <div class="ml-3 col col-stats ml-sm-0">
                                <div class="numbers">
                                    <p class="card-category">Pending withdrawals</p>
                                    <h4 class="card-title">
                                        <?php echo e(Number::currency($chart_pendwithdraw, $settings->s_currency)); ?>

                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-icon">
                                <div class="text-center icon-big icon-primary bubble-shadow-small">
                                    <i class="flaticon-success"></i>
                                </div>
                            </div>
                            <div class="ml-3 col col-stats ml-sm-0">
                                <div class="numbers">
                                    <p class="card-category">Pending deposits</p>
                                    <h4 class="card-title">
                                        <?php echo e(Number::currency($chart_pendepsoit, $settings->s_currency)); ?>

                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End of Dashboard Stats  -->
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view users registration chart')): ?>
        <div class="row">
            <div class="col-md-8">
                <div class="card" style="height: 450px">
                    <div class="card-header d-flex justify-content-between">
                        <div>
                            <h4 class="mb-0 font-weight-bold">Users Statistics</h4>
                            <small class="mt-0">Reload page if chart is not visible.</small>
                        </div>
                        <div class="d-flex align-items-center">
                            <?php if (isset($component)) { $__componentOriginalf26909af655deaf31c8e20175813a5a0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf26909af655deaf31c8e20175813a5a0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.spinner','data' => ['wire:loading' => true,'wire:target' => 'year']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['wire:loading' => true,'wire:target' => 'year']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf26909af655deaf31c8e20175813a5a0)): ?>
<?php $attributes = $__attributesOriginalf26909af655deaf31c8e20175813a5a0; ?>
<?php unset($__attributesOriginalf26909af655deaf31c8e20175813a5a0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf26909af655deaf31c8e20175813a5a0)): ?>
<?php $component = $__componentOriginalf26909af655deaf31c8e20175813a5a0; ?>
<?php unset($__componentOriginalf26909af655deaf31c8e20175813a5a0); ?>
<?php endif; ?>
                            <select class="form-control" wire:model.live='year'>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option><?php echo e($year); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('livewire-column-chart', ['columnChartModel' => $regChart]);

$__html = app('livewire')->mount($__name, $__params, ''.e($regChart->reactiveKey()).'', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card">
                    <div class="card-body" style="height: 450px; overflow-y: auto">
                        <div>
                            <h4 class="font-weight-bold">
                                Recent Sessions
                                <i class="bi bi-circle-fill text-success"></i>
                            </h4>
                        </div>
                        <div class="card-list">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $usersOnline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <!--[if BLOCK]><![endif]--><?php if(!is_null($user)): ?>
                                    <a href="<?php echo e(route('admin.users.singleUser', ['user' => $user])); ?>"
                                        <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>>
                                        <div class="shadow-sm item-list d-flex">
                                            <div class="ml-3 info-user text-decoration-none">
                                                <div class="username font-weight-bolder"><?php echo e($user->name); ?></div>
                                                <div class="status"><?php echo e($user->email); ?></div>
                                            </div>
                                            <div>
                                                <i class="fa fa-arrow-right"></i>
                                            </div>
                                        </div>
                                    </a>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="row">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view activty log')): ?>
            <div class="col-md-8">
                <div class="card full-height">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="font-weight-bold">Activity Log</h4>
                        </div>
                        <div>
                            <a href="<?php echo e(route('admin.platform.activitiesLog')); ?>"
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>>View All</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <ol class="activity-feed">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="feed-item feed-item-secondary d-lg-flex justify-content-between">
                                    <div>
                                        <time class="date" datetime="9-25">
                                            <?php echo e($activity->created_at->toDayDateTimeString()); ?>

                                        </time>
                                        <span class="text">
                                            <?php echo e($activity->description); ?>

                                        </span>
                                    </div>
                                    <div>
                                        <span class="text">
                                            <i class="bi bi-person"></i>
                                            <?php echo e($activity->causer->name); ?>

                                        </span>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </ol>
                        <!--[if BLOCK]><![endif]--><?php if($activities->count() < 1): ?>
                            <div class="text-center">
                                <?php if (isset($component)) { $__componentOriginalf93c233e0d4ceea9c88c0d88798bcfbc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf93c233e0d4ceea9c88c0d88798bcfbc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.no-data','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('no-data'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf93c233e0d4ceea9c88c0d88798bcfbc)): ?>
<?php $attributes = $__attributesOriginalf93c233e0d4ceea9c88c0d88798bcfbc; ?>
<?php unset($__attributesOriginalf93c233e0d4ceea9c88c0d88798bcfbc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf93c233e0d4ceea9c88c0d88798bcfbc)): ?>
<?php $component = $__componentOriginalf93c233e0d4ceea9c88c0d88798bcfbc; ?>
<?php unset($__componentOriginalf93c233e0d4ceea9c88c0d88798bcfbc); ?>
<?php endif; ?>
                                <h4 class=" font-weight-bold">No Activity Logged.</h4>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view other stats')): ?>
            <div class="col-md-4">
                <div class="card full-height">
                    <div class="card-body">
                        <div class="card-title fw-mediumbold">
                            <h4 class="font-weight-bold">Suggested Users</h4>
                        </div>
                        <div class="card-list">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $randomUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="item-list">
                                    <div class="avatar">
                                        <img src="<?php echo e($user->profile_photo_path ? asset('storage/' . $user->profile_photo_path) : asset('dash/images/avatar.svg')); ?>"
                                            alt="..." class="avatar-img rounded-circle">
                                    </div>
                                    <div class="ml-3 info-user">
                                        <div class="username"><?php echo e($user->name); ?></div>
                                        <div class="status"><?php echo e($user->email); ?></div>
                                    </div>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit user')): ?>
                                        <a href="<?php echo e(route('admin.users.singleUser', ['user' => $user])); ?>" class=""
                                            <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>>
                                            <i class="bi bi-arrow-right"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view other stats')): ?>
        <div class="row">
            <div class="col-lg-8">
                <div class="card" style="height: 500px">
                    <div class="card-header d-flex justify-content-between">
                        <div>
                            <h4 class="font-weight-bold">Transactions</h4>
                            <small class="mt-0">Reload page if chart is not visible.</small>
                        </div>
                        <div class="d-flex align-items-center">
                            <?php if (isset($component)) { $__componentOriginalf26909af655deaf31c8e20175813a5a0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf26909af655deaf31c8e20175813a5a0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.spinner','data' => ['wire:loading' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['wire:loading' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf26909af655deaf31c8e20175813a5a0)): ?>
<?php $attributes = $__attributesOriginalf26909af655deaf31c8e20175813a5a0; ?>
<?php unset($__attributesOriginalf26909af655deaf31c8e20175813a5a0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf26909af655deaf31c8e20175813a5a0)): ?>
<?php $component = $__componentOriginalf26909af655deaf31c8e20175813a5a0; ?>
<?php unset($__componentOriginalf26909af655deaf31c8e20175813a5a0); ?>
<?php endif; ?>
                            <select class="form-control" wire:model.live='yearr'>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option><?php echo e($year); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                            <span class="mx-2">-</span>
                            <select class="form-control" wire:model.live='month'>
                                <option value="All">All</option>
                                <option value="01">Jan</option>
                                <option value="02">Feb</option>
                                <option value="03">Mar</option>
                                <option value="04">Apr</option>
                                <option value="05">May</option>
                                <option value="06">Jun</option>
                                <option value="07">Jul</option>
                                <option value="08">Aug</option>
                                <option value="09">Sep</option>
                                <option value="10">Oct</option>
                                <option value="11">Nov</option>
                                <option value="12">Dec</option>
                            </select>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('livewire-line-chart', ['lineChartModel' => $tranChart]);

$__html = app('livewire')->mount($__name, $__params, ''.e($tranChart->reactiveKey()).'', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card" style="height: 500px">
                    <div class="card-header d-flex justify-content-between">
                        <div>
                            <h4 class="font-weight-bold">Top Performing Investments:</h4>
                        </div>
                    </div>
                    <div class="pb-0 card-body">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $topPerformingInv; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="d-flex">
                                <div class="flex-1 pt-1 ml-2">
                                    <h6 class="mb-1 fw-bold"><?php echo e($item->user->name); ?></h6>
                                    <small class="text-muted"><?php echo e($item->plan->name); ?></small>
                                </div>
                                <div class="ml-auto d-flex align-items-center">
                                    <h3 class="text-info fw-bold">
                                        <?php echo e(Number::currency($item->profit_earned, $settings->s_currency)); ?>

                                    </h3>
                                </div>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php if(!$loop->last): ?>
                                <div class="separator-dashed"></div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-center">
                                <h5 class="font-weight-bold">No Active Investment</h5>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

</div>

 <?php $__env->slot('scripts', null, []); ?> 
    <script src="https://6figs.sbrbot.trading/vendor/livewire-charts/app.js"></script>
 <?php $__env->endSlot(); ?>





<?php /**PATH /home/sbrbot/6figs.sbrbot.trading/resources/views/livewire/admin/dashboard.blade.php ENDPATH**/ ?>