<style>
/* Base styles */
.chat-widget {
    position: fixed;
    bottom: 2rem;
    right: 2rem;
    z-index: 50;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}

/* Chat toggle button */
.chat-toggle {
    width: 4rem;
    height: 4rem;
    background-color: #2563eb;
    color: white;
    border-radius: 50%;
    border: none;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    transition: background-color 0.2s;
    cursor: pointer;
}

.chat-toggle i {
    font-size: 1.75rem; /* Increased from default size */
}

.chat-toggle:hover {
    background-color: #1d4ed8;
}

/* Unread badge */
.unread-badge {
    position: absolute;
    top: -0.25rem;
    right: -0.25rem;
    background-color: #ef4444;
    color: white;
    font-size: 0.75rem;
    width: 1.25rem;
    height: 1.25rem;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.unread-badg {
    position: absolute;
    top: 6rem;
    right: 1rem;
    background-color: #ef4444;
    color: white;
    font-size: 0.75rem;
    width: 1.25rem;
    height: 1.25rem;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Chat window */
.chat-window {
    position: absolute;
    bottom: 5rem;
    right: 0;
    width: 24rem;
    background-color: #111827;
    border-radius: 0.5rem;
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    border: 1px solid #374151;
    overflow: hidden;
}

/* Chat header */
.chat-header {
    background-color: #1f2937;
    color: white;
    padding: 1rem;
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.header-title {
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.header-actions {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.end-chat-button {
    display: flex;
    align-items: center;
    padding: 0.5rem 0.75rem;
    background-color: rgba(239, 68, 68, 0.1);
    color: #ef4444;
    border: none;
    border-radius: 0.375rem;
    font-size: 0.875rem;
    transition: all 0.2s;
    cursor: pointer;
}

.end-chat-button:hover {
    background-color: rgba(239, 68, 68, 0.2);
}

.end-chat-button i {
    margin-right: 0.375rem;
    font-size: 0.875rem;
}

.close-button {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 2rem;
    height: 2rem;
    background-color: rgba(255, 255, 255, 0.1);
    color: #9ca3af;
    border: none;
    border-radius: 0.375rem;
    transition: all 0.2s;
    cursor: pointer;
}

.close-button:hover {
    background-color: rgba(255, 255, 255, 0.15);
    color: white;
}

.close-button i {
    font-size: 0.875rem;
}


/* Chat container */
.chat-container {
    height: 500px;
    display: flex;
    flex-direction: column;
}

/* Users list */
.users-list {
    flex: 1;
    overflow-y: auto;
    background-color: #111827;
}

.user-item {
    padding: 1rem;
    border-bottom: 1px solid #1f2937;
    transition: background-color 0.2s;
    cursor: pointer;
}

.user-item:hover {
    background-color: #1f2937;
}

.user-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.user-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.user-avatar {
    width: 3rem;
    height: 3rem;
    background-color: #374151;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.125rem;
}

.user-details h6 {
    color: white;
    font-weight: 500;
    margin: 0;
}

.user-message {
    font-size: 0.875rem;
    color: #9ca3af;
    margin: 0;
    max-width: 200px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

/* Messages container */
.messages-container {
    height: 100%;
    display: flex;
    flex-direction: column;
}

.messages-list {
    flex-grow: 1;
    overflow: auto;
    padding: 1rem;
    display: flex;
    flex-direction: column;
    gap: 1rem;
    background-color: #111827;
}

/* Message bubbles */
.message {
    display: flex;
    max-width: 100%;
}

.message.admin {
    justify-content: flex-end;
}

.message-content {
    padding: 0.5rem 1rem;
    border-radius: 1rem;
    color: white;
    position: relative;
}

.message.user .message-content {
    background-color: #374151;
    border-bottom-left-radius: 0;
}

.message.admin .message-content {
    background-color: #2563eb;
    border-bottom-right-radius: 0;
}

.message-text {
    font-size: 0.875rem;
    word-break: break-word;
}

.message-time {
    font-size: 0.75rem;
    margin-top: 0.25rem;
}

.message.user .message-time {
    color: #9ca3af;
}

.message.admin .message-time {
    color: #bfdbfe;
}

/* Input area */
.chat-input {
    padding: 1rem;
    border-top: 1px solid #374151;
    background-color: #1f2937;
}

.input-container {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.file-upload {
    cursor: pointer;
}

.file-button {
    width: 2.5rem;
    height: 2.5rem;
    background-color: #374151;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #9ca3af;
    transition: all 0.2s;
}

.file-button:hover {
    background-color: #4b5563;
    color: white;
}

.message-input {
    flex: 1;
    background-color: #374151;
    border: 1px solid #4b5563;
    border-radius: 9999px;
    padding: 0.5rem 1rem;
    color: white;
    font-size: 0.875rem;
}

.message-input::placeholder {
    color: #9ca3af;
}

.message-input:focus {
    outline: none;
    border-color: #2563eb;
    box-shadow: 0 0 0 2px rgba(37, 99, 235, 0.2);
}

.send-button {
    width: 2.5rem;
    height: 2.5rem;
    background-color: #2563eb;
    color: white;
    border: none;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: background-color 0.2s;
}

.send-button:hover {
    background-color: #1d4ed8;
}

/* File preview */
.file-preview {
    padding: 0.5rem 1rem;
    background-color: #1f2937;
    border-top: 1px solid #374151;
}

.preview-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    background-color: #374151;
    border-radius: 0.25rem;
    padding: 0.5rem;
}

.file-name {
    color: #d1d5db;
    font-size: 0.875rem;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

/* Modal styles */
.modal-overlay {
    position: fixed;
    inset: 0;
    background-color: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 50;
}

.modal-content {
    background-color: #1f2937;
    padding: 1.5rem;
    border-radius: 0.5rem;
    max-width: 24rem;
    margin: 1rem;
}

.modal-title {
    color: white;
    font-weight: 600;
    font-size: 1.125rem;
    margin-bottom: 1rem;
}

.modal-text {
    color: #d1d5db;
    margin-bottom: 1.5rem;
}

.modal-actions {
    display: flex;
    justify-content: flex-end;
    gap: 0.75rem;
}

.modal-button {
    padding: 0.5rem 1rem;
    border-radius: 0.25rem;
    font-size: 0.875rem;
    cursor: pointer;
}

.modal-cancel {
    color: #d1d5db;
    background: none;
    border: none;
}

.modal-cancel:hover {
    color: white;
}

.modal-confirm {
    background-color: #ef4444;
    color: white;
    border: none;
}

.modal-confirm:hover {
    background-color: #dc2626;
}

/* Utility classes */
.hidden {
    display: none;
}
</style>
<div id="chat-widget" class="chat-widget">
    <!-- Pusher Script -->
    <script src="https://js.pusher.com/8.0/pusher.min.js"></script>   
    <!-- Chat Icon Button -->
    <button onclick="toggleChat()" class="chat-toggle">
        <i class="fas fa-comments"></i>
        <span id="unread-badge" class="unread-badge hidden">0</span>
    </button>

    <!-- Chat Window -->
    <div id="chat-window" class="chat-window hidden">
        <!-- Chat Header -->
        <div class="chat-header">
            <div class="header-content">
                <div id="chat-header" class="header-title">
                    <i class="fas fa-headset"></i>
                    <span>Support Inbox</span>
                </div>
                <div class="header-actions">
                    <button id="end-chat-btn" onclick="confirmEndChat()" class="end-chat-button hidden">
                        <i class="fas fa-times-circle"></i>
                        End Chat
                    </button>
                    <button onclick="toggleChat()" class="close-button">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        </div>

        <div class="chat-container">
            <!-- Users List -->
            <div id="users-list" class="users-list">
                <!-- Users will be loaded here -->
            </div>

            <!-- Messages Container -->
            <div id="messages-container" class="messages-container hidden">
                <div id="typing-indicator" class="typing-indicator hidden">
                    User is typing...
                </div>
                
                <div id="messages-list" class="messages-list">
                    <!-- Messages will be loaded here -->
                </div>

                <!-- File Preview -->
                <div id="file-preview" class="file-preview hidden">
                    <div class="preview-content">
                        <span id="file-name" class="file-name"></span>
                        <button onclick="removeFile()" class="close-button">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>

                <!-- Message Input -->
                <div class="chat-input">
                    <div class="input-container">
                        <label class="file-upload">
                            <input type="file" 
                                   id="file-input" 
                                   class="hidden" 
                                   accept="image/*,.pdf,.doc,.docx">
                            <div class="file-button">
                                <i class="fas fa-paperclip"></i>
                            </div>
                        </label>
                        <input type="text" 
                               id="message-input"
                               class="message-input"
                               placeholder="Type your message...">
                        <button onclick="sendMessage()" class="send-button">
                            <i class="fas fa-paper-plane"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- End Chat Confirmation Modal -->
    <div id="end-chat-modal" class="modal-overlay hidden">
        <div class="modal-content">
            <h3 class="modal-title">End Chat</h3>
            <p class="modal-text">Are you sure you want to end this chat? All messages and files will be permanently deleted.</p>
            <div class="modal-actions">
                <button onclick="hideEndChatModal()" class="modal-button modal-cancel">
                    Cancel
                </button>
                <button onclick="executeEndChat()" class="modal-button modal-confirm">
                    End Chat
                </button>
            </div>
        </div>
    </div>
</div>

<script>
let selectedUser = null;
let selectedFile = null;
let typingTimeout = null;
let messageRefreshInterval;
let unreadCheckInterval;

function loadUsers() {
    fetch('/admin/chat/users')
        .then(response => response.json())
        .then(users => {
            const usersList = document.getElementById('users-list');
            usersList.innerHTML = users.map(user => `
                <div class="user-item" onclick="selectUser(${user.id}, '${user.name}')">
                    <div class="user-content">
                        <div class="user-info">
                            <div class="user-avatar">
                                ${user.name.charAt(0).toUpperCase()}
                            </div>
                            <div class="user-details">
                                <h6>${user.name}</h6>
                                <p class="user-message">
                                    ${user.last_message || 'No messages yet'}
                                </p>
                            </div>
                        </div>
                        ${user.unread_count ? `
                            <span class="unread-badg">
                                ${user.unread_count}
                            </span>
                        ` : ''}
                    </div>
                </div>
            `).join('');
            usersList.classList.remove('hidden');
            document.getElementById('messages-container').classList.add('hidden');
            document.getElementById('chat-header').innerHTML = '<i class="fas fa-headset"></i> <span>Support Inbox</span>';
            checkUnreadMessages(users);
        });
}

function loadMessages() {
    if (!selectedUser) return;
    
    fetch(`/admin/chat/messages/${selectedUser}`)
        .then(response => response.json())
        .then(messages => {
            const messagesList = document.getElementById('messages-list');
            messagesList.innerHTML = messages.map(message => {
                const isAdminMessage = message.is_admin_message;
                let content = message.message ? `<div class="message-text">${message.message}</div>` : '';
                
                // Handle file attachments
                if (message.file_url) {
                    if (message.file_type?.startsWith('image/')) {
                        content += `
                            <div class="message-attachment">
                                <a href="${message.file_url}" target="_blank">
                                    <img src="${message.file_url}" 
                                         class="message-image" 
                                         alt="Attached image"
                                         style="max-width: 200px; border-radius: 0.5rem;">
                                </a>
                            </div>
                        `;
                    } else {
                        content += `
                            <div class="message-attachment">
                                <a href="${message.file_url}" 
                                   class="file-download"
                                   target="_blank" 
                                   download="${message.file_name}">
                                    <i class="fas fa-file-download"></i>
                                    <span class="file-name">${message.file_name}</span>
                                </a>
                            </div>
                        `;
                    }
                }

                return `
                    <div class="message ${isAdminMessage ? 'admin' : 'user'}">
                        <div class="message-content">
                            ${content}
                            <div class="message-time">
                                ${new Date(message.created_at).toLocaleTimeString([], { 
                                    hour: '2-digit', 
                                    minute: '2-digit',
                                    hour12: true 
                                })}
                            </div>
                        </div>
                    </div>
                `;
            }).join('');
            messagesList.scrollTop = messagesList.scrollHeight;

            // Show end chat button if there are messages
            const endChatBtn = document.getElementById('end-chat-btn');
            if (endChatBtn) {
                messages.length > 0 ? endChatBtn.classList.remove('hidden') : endChatBtn.classList.add('hidden');
            }
        });
}

function toggleChat() {
    const chatWindow = document.getElementById('chat-window');
    if (chatWindow.classList.contains('hidden')) {
        chatWindow.classList.remove('hidden');
        loadUsers();
        messageRefreshInterval = setInterval(loadUsers, 5000);
        clearInterval(unreadCheckInterval);
    } else {
        chatWindow.classList.add('hidden');
        clearInterval(messageRefreshInterval);
        unreadCheckInterval = setInterval(checkUnreadCount, 5000);
    }
}

function selectUser(userId, userName) {
    selectedUser = userId;
    document.getElementById('users-list').classList.add('hidden');
    document.getElementById('messages-container').classList.remove('hidden');
    document.getElementById('chat-header').innerHTML = `
        <div class="header-title">
            <i class="fas fa-arrow-left" style="cursor: pointer; margin-right: 0.75rem;" onclick="backToUsers()"></i>
            <span>${userName}</span>
        </div>
    `;
    loadMessages();
    clearInterval(messageRefreshInterval);
    messageRefreshInterval = setInterval(loadMessages, 3000);
}

function backToUsers() {
    selectedUser = null;
    document.getElementById('messages-container').classList.add('hidden');
    document.getElementById('users-list').classList.remove('hidden');
    document.getElementById('chat-header').innerHTML = '<i class="fas fa-headset"></i> <span>Support Inbox</span>';
    document.getElementById('end-chat-btn').classList.add('hidden');
    clearInterval(messageRefreshInterval);
    messageRefreshInterval = setInterval(loadUsers, 5000);
    loadUsers();
}

function sendMessage() {
    if (!selectedUser) return;
    
    const input = document.getElementById('message-input');
    const message = input.value.trim();
    
    if (!message && !selectedFile) return;
    
    const formData = new FormData();
    if (message) formData.append('message', message);
    if (selectedFile) {
        const maxSize = 5 * 1024 * 1024; // 5MB
        if (selectedFile.size > maxSize) {
            alert('File size should not exceed 5MB');
            return;
        }
        formData.append('file', selectedFile);
    }
    formData.append('user_id', selectedUser);

    const sendButton = document.querySelector('.send-button');
    const fileInput = document.getElementById('file-input');
    input.disabled = true;
    sendButton.disabled = true;
    fileInput.disabled = true;

    fetch('/admin/chat/send', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: formData
    })
    .then(response => {
        if (!response.ok) throw new Error('Network response was not ok');
        return response.json();
    })
    .then(() => {
        input.value = '';
        removeFile();
        loadMessages();
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to send message. Please try again.');
    })
    .finally(() => {
        input.disabled = false;
        sendButton.disabled = false;
        fileInput.disabled = false;
    });
}

function handleFile(file) {
    if (file) {
        const maxSize = 5 * 1024 * 1024; // 5MB
        if (file.size > maxSize) {
            alert('File size should not exceed 5MB');
            return false;
        }

        const preview = document.getElementById('file-preview');
        const fileName = document.getElementById('file-name');
        
        if (file.type.startsWith('image/')) {
            const reader = new FileReader();
            reader.onload = function(e) {
                fileName.innerHTML = `
                    <div class="preview-file">
                        <img src="${e.target.result}" class="preview-image" 
                             style="width: 2rem; height: 2rem; object-fit: cover; border-radius: 0.25rem; margin-right: 0.5rem;">
                        <span class="preview-name">${file.name}</span>
                    </div>
                `;
            };
            reader.readAsDataURL(file);
        } else {
            fileName.innerHTML = `
                <div class="preview-file">
                    <i class="fas fa-file" style="margin-right: 0.5rem;"></i>
                    <span class="preview-name">${file.name}</span>
                </div>
            `;
        }
        
        preview.classList.remove('hidden');
        selectedFile = file;
        return true;
    }
    return false;
}

function removeFile() {
    selectedFile = null;
    document.getElementById('file-input').value = '';
    document.getElementById('file-preview').classList.add('hidden');
}

function checkUnreadMessages(users) {
    const totalUnread = users.reduce((sum, user) => sum + (user.unread_count || 0), 0);
    const badge = document.getElementById('unread-badge');
    if (totalUnread > 0) {
        badge.textContent = totalUnread > 99 ? '99+' : totalUnread;
        badge.classList.remove('hidden');
    } else {
        badge.classList.add('hidden');
    }
}

function showEndChatModal() {
    document.getElementById('end-chat-modal').classList.remove('hidden');
}

function hideEndChatModal() {
    document.getElementById('end-chat-modal').classList.add('hidden');
}

function confirmEndChat() {
    showEndChatModal();
}

function executeEndChat() {
    hideEndChatModal();
    if (!selectedUser) return;
    
    fetch('/admin/chat/end', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({
            user_id: selectedUser
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            document.getElementById('end-chat-btn').classList.add('hidden');
            backToUsers();
            // Show success notification
            const toast = document.createElement('div');
            toast.className = 'toast-notification';
            toast.textContent = 'Chat ended successfully';
            document.body.appendChild(toast);
            setTimeout(() => toast.remove(), 3000);
        }
    })
    .catch(error => console.error('Error:', error));
}

function checkUnreadCount() {
    fetch('/admin/chat/unread-total')
        .then(response => response.json())
        .then(data => {
            const badge = document.getElementById('unread-badge');
            if (data.count > 0) {
                badge.textContent = data.count > 99 ? '99+' : data.count;
                badge.classList.remove('hidden');
            } else {
                badge.classList.add('hidden');
            }
        });
}

// Initialize Pusher
const pusher = new Pusher('<?php echo e(config('broadcasting.connections.pusher.key')); ?>', {
    cluster: '<?php echo e(config('broadcasting.connections.pusher.options.cluster')); ?>',
    encrypted: true
});

const channel = pusher.subscribe('chat');

// Listen for new messages
channel.bind('NewMessage', function(data) {
    if (data.message.to_user == <?php echo e(auth()->id()); ?>) {
        if (selectedUser && selectedUser == data.message.from_user) {
            loadMessages();
        } else {
            loadUsers();
        }
    }
});

// Listen for chat ended event
channel.bind('ChatEnded', function(data) {
    if (selectedUser && selectedUser == data.user_id) {
        backToUsers();
        const toast = document.createElement('div');
        toast.className = 'toast-notification warning';
        toast.textContent = 'Chat has been ended';
        document.body.appendChild(toast);
        setTimeout(() => toast.remove(), 3000);
    }
});

// Initial setup
document.addEventListener('DOMContentLoaded', function() {
    loadUsers();
    checkUnreadCount();
    unreadCheckInterval = setInterval(checkUnreadCount, 5000);
    
    // Handle Enter key in message input
    document.getElementById('message-input').addEventListener('keypress', function(e) {
        if (e.key === 'Enter' && !e.shiftKey) {
            e.preventDefault();
            sendMessage();
        }
    });
    
    // Handle file input changes
    document.getElementById('file-input').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            handleFile(file);
        }
    });
});
</script>




<?php /**PATH /home/sbrbot/6figs.sbrbot.trading/resources/views/layouts/includes/chat/admin-widget.blade.php ENDPATH**/ ?>