<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>6FigsTrade - Setup</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <x-theme-colors />
</head>
<body class="bg-theme-primary min-h-screen">
    <div class="container mx-auto px-4 py-8">
        <div class="max-w-2xl mx-auto">
            <!-- Header -->
            <div class="text-center mb-8">
                <div class="bg-theme-secondary rounded-2xl p-6 mb-6">
                    <i class="fas fa-tools text-theme-primary text-5xl mb-4"></i>
                    <h1 class="text-3xl font-bold text-white mb-2">6FigsTrade Setup</h1>
                    <p class="text-gray-400">Easy one-click setup for your trading platform</p>
                </div>
            </div>

            @if($setupComplete)
                <!-- Setup Already Complete -->
                <div class="bg-theme-secondary rounded-xl p-6 text-center">
                    <i class="fas fa-check-circle text-green-500 text-4xl mb-4"></i>
                    <h2 class="text-xl font-semibold text-white mb-2">Setup Already Complete!</h2>
                    <p class="text-gray-400 mb-4">Your 6FigsTrade application is ready to use.</p>
                    <a href="/" class="bg-theme-primary text-white px-6 py-3 rounded-lg hover:brightness-110 transition-all inline-flex items-center gap-2">
                        <i class="fas fa-home"></i>
                        Go to Application
                    </a>
                    <div class="mt-4">
                        <a href="{{ route('setup.reset') }}" class="text-gray-400 hover:text-white text-sm">
                            <i class="fas fa-redo"></i> Run Setup Again
                        </a>
                    </div>
                </div>
            @else
                <!-- Setup Form -->
                <div class="bg-theme-secondary rounded-xl p-6">
                    <h2 class="text-xl font-semibold text-white mb-4">
                        <i class="fas fa-rocket text-theme-primary mr-2"></i>
                        Initialize Your Application
                    </h2>
                    
                    <div class="bg-blue-900/20 border border-blue-500/30 rounded-lg p-4 mb-6">
                        <div class="flex items-start gap-3">
                            <i class="fas fa-info-circle text-blue-400 mt-1"></i>
                            <div>
                                <h3 class="text-blue-400 font-medium mb-1">What this setup does:</h3>
                                <ul class="text-sm text-blue-200 space-y-1">
                                    <li>• Creates storage links for file uploads (logos, images)</li>
                                    <li>• Clears application caches</li>
                                    <li>• Sets up required directories</li>
                                    <li>• Prepares environment configuration</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-4 mb-6">
                        <div id="setupResults" class="hidden space-y-3"></div>
                    </div>

                    <div class="flex gap-4">
                        <button id="runSetup" class="bg-theme-primary text-white px-8 py-3 rounded-lg hover:brightness-110 transition-all flex items-center gap-2 flex-1">
                            <i class="fas fa-play"></i>
                            <span>Start Setup</span>
                        </button>
                    </div>

                    <div id="loadingIndicator" class="hidden text-center py-8">
                        <i class="fas fa-spinner fa-spin text-theme-primary text-3xl mb-4"></i>
                        <p class="text-gray-400">Running setup... Please wait</p>
                    </div>
                </div>

                <!-- Manual Instructions -->
                <div class="bg-theme-secondary rounded-xl p-6 mt-6">
                    <h3 class="text-lg font-semibold text-white mb-4">
                        <i class="fas fa-wrench text-theme-primary mr-2"></i>
                        Alternative: Manual Setup
                    </h3>
                    <div class="text-sm text-gray-400 space-y-2">
                        <p>If the automatic setup doesn't work, you can run these commands manually:</p>
                        <div class="bg-theme-tertiary rounded p-3 font-mono text-xs">
                            <div>php artisan storage:link</div>
                            <div>php artisan cache:clear</div>
                            <div>php artisan config:clear</div>
                        </div>
                        <p class="text-xs">Ask your hosting provider if you need help running these commands.</p>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const runSetupBtn = document.getElementById('runSetup');
            const loadingIndicator = document.getElementById('loadingIndicator');
            const setupResults = document.getElementById('setupResults');

            if (runSetupBtn) {
                runSetupBtn.addEventListener('click', function() {
                    // Show loading
                    this.style.display = 'none';
                    loadingIndicator.classList.remove('hidden');
                    
                    // Run setup via AJAX
                    fetch('{{ route("setup.run") }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({})
                    })
                    .then(response => response.json())
                    .then(data => {
                        // Hide loading
                        loadingIndicator.classList.add('hidden');
                        
                        // Show results
                        setupResults.classList.remove('hidden');
                        setupResults.innerHTML = '';
                        
                        // Add overall status
                        const statusDiv = document.createElement('div');
                        statusDiv.className = `p-4 rounded-lg border ${data.success ? 'bg-green-900/20 border-green-500/30' : 'bg-yellow-900/20 border-yellow-500/30'}`;
                        statusDiv.innerHTML = `
                            <div class="flex items-center gap-3">
                                <i class="fas ${data.success ? 'fa-check-circle text-green-400' : 'fa-exclamation-triangle text-yellow-400'}"></i>
                                <span class="${data.success ? 'text-green-400' : 'text-yellow-400'} font-medium">${data.message}</span>
                            </div>
                        `;
                        setupResults.appendChild(statusDiv);
                        
                        // Add individual results
                        Object.entries(data.results).forEach(([key, result]) => {
                            const resultDiv = document.createElement('div');
                            const statusClass = result.status === 'success' ? 'text-green-400' : 
                                              result.status === 'warning' ? 'text-yellow-400' : 'text-red-400';
                            const iconClass = result.status === 'success' ? 'fa-check' : 
                                            result.status === 'warning' ? 'fa-exclamation-triangle' : 'fa-times';
                            
                            resultDiv.className = 'flex items-start gap-3 p-3 bg-theme-tertiary rounded-lg';
                            resultDiv.innerHTML = `
                                <i class="fas ${iconClass} ${statusClass} mt-1"></i>
                                <div>
                                    <div class="font-medium text-white capitalize">${key.replace('_', ' ')}</div>
                                    <div class="text-sm text-gray-400">${result.message}</div>
                                </div>
                            `;
                            setupResults.appendChild(resultDiv);
                        });
                        
                        // Add success actions
                        if (data.success) {
                            const actionsDiv = document.createElement('div');
                            actionsDiv.className = 'text-center pt-4';
                            actionsDiv.innerHTML = `
                                <a href="/" class="bg-theme-primary text-white px-6 py-3 rounded-lg hover:brightness-110 transition-all inline-flex items-center gap-2">
                                    <i class="fas fa-home"></i>
                                    Go to Application
                                </a>
                            `;
                            setupResults.appendChild(actionsDiv);
                        }
                    })
                    .catch(error => {
                        console.error('Setup failed:', error);
                        loadingIndicator.classList.add('hidden');
                        setupResults.classList.remove('hidden');
                        setupResults.innerHTML = `
                            <div class="p-4 rounded-lg border bg-red-900/20 border-red-500/30">
                                <div class="flex items-center gap-3">
                                    <i class="fas fa-times-circle text-red-400"></i>
                                    <span class="text-red-400 font-medium">Setup failed. Please try manual setup or contact support.</span>
                                </div>
                            </div>
                        `;
                    });
                });
            }
        });
    </script>
</body>
</html>
