<div class="p-1">
    <x-danger-alert />
    <x-success-alert />
    
    @if ($hasSubscribe)
        {{-- Success State --}}
        <div class="text-center space-y-6">
            <div class="w-16 h-16 mx-auto bg-theme-primary/10 rounded-full flex items-center justify-center">
                <i class="fas fa-check text-theme-primary text-2xl"></i>
            </div>
            
            <div class="space-y-6">
                {{-- Invite Link Section --}}
                <div class="bg-theme-tertiary rounded-xl p-4">
                    <div class="relative">
                        <input 
                            type="text" 
                            class="w-full bg-theme-quaternary border border-gray-800 rounded-lg px-4 py-3 text-gray-100 font-mono text-sm focus:outline-none focus:border-theme-primary"
                            wire:model='inviteLink'
                            readonly>
                    </div>
                </div>
                
                {{-- Warning Message --}}
                <div class="bg-yellow-500/10 border border-yellow-500/20 rounded-xl p-4">
                    <div class="flex items-start gap-3">
                        <i class="fas fa-exclamation-triangle text-yellow-500 mt-1"></i>
                        <p class="text-sm text-gray-400">
                            {{ __('t.copy_invite_link_warning') }}
                        </p>
                    </div>
                </div>
                
                {{-- Finish Button --}}
                <a href="{{ route('user.tradeSignals', ['page' => '1']) }}"
                    class="inline-flex items-center justify-center gap-2 w-full bg-gradient-theme-primary text-black px-6 py-3 rounded-xl hover:brightness-110 transition-all font-medium">
                    <i class="fas fa-check"></i>
                    {{ __('t.finish_copying') }}
                </a>
            </div>
        </div>
    @else
        {{-- Subscription Form --}}
        <form wire:submit='subscribe' class="space-y-6">
            {{-- Duration Selection --}}
            <div class="space-y-2">
                <label class="text-sm text-gray-400">{{ __('t.choose_duration') }}</label>
                <div class="relative">
                    <select 
                        class="w-full appearance-none bg-theme-tertiary border border-gray-800 rounded-xl px-4 py-3 text-gray-100 focus:outline-none focus:border-theme-primary transition-colors"
                        wire:model.live='duration'>
                        <option value="Choose">{{ __('t.choose_duration_option') }}</option>
                        <option value="Monthly">{{ __('t.monthly') }}</option>
                        <option value="Quarterly">{{ __('t.quarterly') }}</option>
                        <option value="Yearly">{{ __('t.yearly') }}</option>
                    </select>
                    <div class="absolute right-4 top-1/2 -translate-y-1/2 pointer-events-none">
                        <i class="fas fa-chevron-down text-gray-400"></i>
                    </div>
                </div>
            </div>

            {{-- Amount Input --}}
            <div class="space-y-2">
                <label class="text-sm text-gray-400">
                    {{ __('t.amount_with_currency') }} ({{ $settings->currency }})
                </label>
                <div class="relative">
                    <div class="absolute left-4 top-1/2 -translate-y-1/2 text-theme-primary">
                        {{ $settings->currency }}
                    </div>
                    <x-form.input 
                        wire:model='amount' 
                        name="amount" 
                        :readOnly="true"
                        class="w-full pl-8 bg-theme-tertiary border border-gray-800 rounded-xl px-4 py-3 text-gray-100 focus:outline-none focus:border-theme-primary font-medium transition-colors" />
                </div>
                <div class="flex items-center gap-2 text-sm text-gray-400">
                    <i class="fas fa-info-circle text-theme-primary"></i>
                    <span>{{ __('t.amount_deducted_account_balance') }}</span>
                </div>
            </div>

            {{-- Telegram ID Input --}}
            <div class="space-y-2">
                <label class="text-sm text-gray-400">{{ __('t.telegram_user_id') }}</label>
                <div class="relative">
                    <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400">
                        <i class="fab fa-telegram"></i>
                    </div>
                    <x-form.input 
                        name="telegram_id" 
                        wire:model='telegram_id'
                        required
                        placeholder="{{ __('t.enter_telegram_id_placeholder') }}"
                        class="w-full pl-10 bg-theme-tertiary border border-gray-800 rounded-xl px-4 py-3 text-gray-100 focus:outline-none focus:border-theme-primary transition-colors" />
                </div>
                <p class="text-sm text-gray-400 flex items-center gap-2">
                    <i class="fas fa-external-link-alt text-theme-primary"></i>
                    <span>{{ __('t.follow') }}</span>
                    <a href="https://medium.com/block-bastards/how-to-find-your-user-id-on-telegram-a27cb7b732d6"
                        target="_blank"
                        class="text-theme-primary hover:brightness-110 transition-all">
                        {{ __('t.guide_to_get_telegram_id') }}
                    </a>
                </p>
            </div>

            {{-- Submit Button --}}
            <button type="submit"
                class="w-full bg-gradient-theme-primary text-black font-medium px-6 py-4 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-3">
                <div wire:loading wire:target='subscribe'>
                    <i class="fas fa-spinner fa-spin"></i>
                </div>
                <i class="fas fa-check" wire:loading.remove wire:target='subscribe'></i>
                <span>{{ __('t.subscribe') }}</span>
            </button>
        </form>
    @endif
</div>



