<div class="px-2 space-y-8 mt-2">
    {{-- <div class="flex items-center justify-between">
        <div>
            <div class="pl-3 flex items-center text-sm text-gray-400">
                <a href="{{ route('user.dashboard') }}" class="hover:text-theme-primary">{{ __('t.dash') }}</a>
                <i data-lucide="chevron-right" class="w-4 h-4 mx-2"></i>
                <span>{{ __('t.my_courses') }}</span>
            </div>
        </div>
    </div> --}}
    
    <x-danger-alert />
    <x-success-alert />

    <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
        @forelse ($data as $info)
            <div class="bg-theme-secondary rounded-2xl overflow-hidden group hover:shadow-lg hover:shadow-[#2563EB]/5 transition-all duration-300">
                <div class="relative aspect-video">
                    <img 
                        src="{{ str_starts_with($info['course']['image_url'], 'http') ? $info['course']['image_url'] : asset($info['course']['image_url']) }}"
                        alt="{{ $info['course']['title'] }}"
                        class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300">
                    
                    {{-- Progress Overlay --}}
                    <div class="absolute inset-0 bg-gradient-to-t from-[#0F0A1F] to-transparent">
                        <div class="absolute bottom-4 left-4 right-4">
                            <!--
                            <div class="bg-theme-tertiary/80 backdrop-blur rounded-lg p-3">
                                <div class="flex items-center justify-between text-sm text-gray-400 mb-2">
                                    <span>{{ __('t.progress') }}</span>
                                    <span>30%</span>
                                </div>
                                <div class="h-1.5 bg-theme-tertiary rounded-full overflow-hidden">
                                    <div class="h-full w-[30%] bg-theme-primary rounded-full"></div>
                                </div>
                            </div>
                            -->
                        </div>
                    </div>

                    {{-- Play Button --}}
                    <a href="{{ route('user.membership.mycoursedetails', ['id' => $info['course_id']]) }}"
                        @if ($settings->spa_mode) wire:navigate @endif
                        class="absolute inset-0 flex items-center justify-center">
                        <div class="w-16 h-16 bg-theme-primary/20 backdrop-blur rounded-full flex items-center justify-center transform scale-0 group-hover:scale-100 transition-transform duration-300">
                            <i data-lucide="play" class="w-8 h-8 text-theme-primary"></i>
                        </div>
                    </a>
                </div>

                <div class="p-6">
                    <h5 class="text-lg font-medium mb-4 group-hover:text-theme-primary transition-colors">
                        {{ $info['course']['title'] }}
                    </h5>
                    
                    <div class="bg-theme-tertiary rounded-xl p-3 mb-6">
                        <div class="flex items-center gap-2 text-sm">
                            <i data-lucide="book-open" class="w-4 h-4 text-theme-primary"></i>
                            <span class="text-gray-400">{{ count($info['course']['lessons']) }} {{ __('t.lessons') }}</span>
                        </div>
                    </div>

                    <a href="{{ route('user.membership.mycoursedetails', ['id' => $info['course_id']]) }}"
                        @if ($settings->spa_mode) wire:navigate @endif
                        class="flex items-center justify-between bg-theme-primary text-black p-4 rounded-xl hover:bg-theme-primary-dark transition-colors">
                        <span class="font-medium">{{ __('t.continue_learning') }}</span>
                        <i data-lucide="arrow-right" class="w-5 h-5 group-hover:translate-x-1 transition-transform"></i>
                    </a>
                </div>
            </div>
        @empty
            <div class="col-span-full">
                <div class="bg-theme-secondary rounded-2xl p-12 text-center">
                    <div class="bg-theme-tertiary w-20 h-20 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <i data-lucide="book-x" class="w-10 h-10 text-gray-400"></i>
                    </div>
                    <h3 class="text-xl font-medium mb-4">{{ __('t.no_courses_yet') }}</h3>
                    <a href="{{ route('user.membership.courses', ['page' => 1]) }}"
                        @if ($settings->spa_mode) wire:navigate @endif
                        class="inline-flex items-center gap-2 bg-theme-primary text-black px-6 py-3 rounded-xl hover:bg-theme-primary-dark transition-colors">
                        <i data-lucide="search" class="w-5 h-5"></i>
                        {{ __('t.browse_courses') }}
                    </a>
                </div>
            </div>
        @endforelse
    </div>
</div>

<script>
    lucide.createIcons();
</script>



