<div class="w-full p-2 mb-5 md:mb-1">
    <x-danger-alert />
    <x-success-alert />
    
    {{-- Header Section --}}
    <div class="bg-theme-secondary rounded-2xl p-6 mb-6">
        <div class="flex flex-col sm:flex-row items-center justify-between gap-4">
            <div class="flex items-center gap-4">
                <div class="bg-theme-tertiary p-3 rounded-xl">
                    <i data-lucide="briefcase" class="w-6 h-6 text-theme-primary"></i>
                </div>
                <div>
                    <h1 class="text-xl font-medium">{{ __('t.investment_plans') }}</h1>
                    <div class="flex items-center text-sm text-gray-400">
                        <a href="{{ route('user.dashboard') }}" class="hover:text-theme-primary">{{ __('t.dash') }}</a>
                        <i data-lucide="chevron-right" class="w-4 h-4 mx-2"></i>
                        <span>{{ __('t.my_plans') }}</span>
                    </div>
                </div>
            </div>
            <div class="flex items-center gap-4">
                <select 
                    wire:model.live='sort_value'
                    class="bg-theme-tertiary border-2 border-theme-quaternary rounded-xl px-4 py-2 focus:outline-none focus:border-theme-primary text-sm">
                    <option value="All">{{ __('t.all_plans') }}</option>
                    <option value="active">{{ __('t.active') }}</option>
                    <option value="cancelled">{{ __('t.cancelled_inactive') }}</option>
                    <option value="expired">{{ __('t.expired') }}</option>
                </select>
                <div wire:loading wire:target="sort_value">
                    <i data-lucide="loader-2" class="w-5 h-5 text-theme-primary animate-spin"></i>
                </div>
            </div>
        </div>
    </div>

    {{-- Trade Mode Status --}}
    <div class="mb-6">
        @if (auth()->user()->trade_mode)
            <div class="flex items-center gap-3 bg-theme-primary/10 text-theme-primary p-4 rounded-xl">
                <i data-lucide="activity" class="w-5 h-5"></i>
                <span>{{ __('t.trading_mode_active') }}</span>
            </div>
        @else
            <div class="flex items-center gap-3 bg-red-400/10 text-red-400 p-4 rounded-xl">
                <i data-lucide="alert-triangle" class="w-5 h-5"></i>
                <span>{{ __('t.trading_mode_inactive') }}</span>
            </div>
        @endif
    </div>

    {{-- Plans Grid --}}
    <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
        @forelse ($plans as $plan)
            <div class="bg-theme-secondary rounded-2xl hover:shadow-lg hover:shadow-[#2563EB]/5 transition-all duration-300">
                {{-- Header --}}
                <div class="p-6 border-b border-[#1A1428]">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center gap-3">
                            <div class="bg-theme-tertiary p-2 rounded-lg">
                                <i data-lucide="trending-up" class="w-5 h-5 text-theme-primary"></i>
                            </div>
                            <h4 class="font-medium">{{ $plan->plan->name }}</h4>
                        </div>
                        @if ($plan->status == 'active')
                            <div class="flex items-center gap-2 px-3 py-1 rounded-full bg-theme-primary/10 text-theme-primary text-sm">
                                <i data-lucide="check-circle" class="w-4 h-4"></i>
                                <span>{{ __('t.active') }}</span>
                            </div>
                        @elseif($plan->status == 'expired')
                            <div class="flex items-center gap-2 px-3 py-1 rounded-full bg-red-400/10 text-red-400 text-sm">
                                <i data-lucide="clock" class="w-4 h-4"></i>
                                <span>{{ __('t.expired') }}</span>
                            </div>
                        @else
                            <div class="flex items-center gap-2 px-3 py-1 rounded-full bg-red-400/10 text-red-400 text-sm">
                                <i data-lucide="x-circle" class="w-4 h-4"></i>
                                <span>{{ __('t.inactive') }}</span>
                            </div>
                        @endif
                    </div>
                    <div class="flex items-baseline gap-2">
                        <span class="text-2xl font-medium">{{ Number::currency($plan->amount, $settings->s_currency) }}</span>
                        <span class="text-sm text-gray-400">{{ __('t.invested_amount') }}</span>
                    </div>
                </div>

                {{-- Timeline --}}
                <div class="p-6 space-y-4">
                    <div class="flex items-center gap-3">
                        <div class="bg-theme-tertiary p-2 rounded-lg">
                            <i data-lucide="calendar" class="w-4 h-4 text-theme-primary"></i>
                        </div>
                        <div>
                            <div class="text-sm text-gray-400">{{ __('t.started') }}</div>
                            <div>{{ $plan->created_at->format('M d, Y') }}</div>
                        </div>
                    </div>
                    <div class="flex items-center gap-3">
                        <div class="bg-theme-tertiary p-2 rounded-lg">
                            <i data-lucide="calendar-x" class="w-4 h-4 text-theme-primary"></i>
                        </div>
                        <div>
                            <div class="text-sm text-gray-400">{{ __('t.ends') }}</div>
                            <div>{{ $plan->expire_date->format('M d, Y') }}</div>
                        </div>
                    </div>
                </div>

                {{-- Action --}}
                <div class="p-6 border-t border-[#1A1428]">
                    <a href="{{ route('user.investment.plandetails', ['plan' => $plan]) }}"
                        @if ($settings->spa_mode) wire:navigate @endif
                        class="flex items-center justify-between p-3 bg-theme-tertiary text-theme-primary rounded-xl hover:bg-theme-quaternary transition-colors group">
                        <span>{{ __('t.view_details') }}</span>
                        <i data-lucide="arrow-right" class="w-5 h-5 group-hover:translate-x-1 transition-transform"></i>
                    </a>
                </div>
            </div>
        @empty
            <div class="md:col-span-2 lg:col-span-3">
                <div class="bg-theme-secondary rounded-2xl p-12 text-center">
                    <div class="max-w-sm mx-auto">
                        <div class="bg-theme-tertiary w-20 h-20 rounded-2xl flex items-center justify-center mx-auto mb-6">
                            <i data-lucide="package" class="w-10 h-10 text-gray-400"></i>
                        </div>
                        <h5 class="text-xl font-medium mb-4">{{ __('t.no_active_plans') }}</h5>
                        @if ($sort_value == 'All')
                            <a href="{{ route('user.investment.buyplan') }}" 
                                class="inline-flex items-center gap-2 bg-theme-primary text-black px-6 py-3 rounded-xl hover:bg-theme-primary-dark transition-colors">
                                <i data-lucide="plus" class="w-5 h-5"></i>
                                {{ __('t.start_investing') }}
                            </a>
                        @endif
                    </div>
                </div>
            </div>
        @endforelse
    </div>
</div>



