<div class="p-6">
    {{-- Bank Transfer Payment --}}
    @if ($method->name == 'Bank Transfer')
        <div class="max-w-2xl mx-auto">
            {{-- Bank Information Card --}}
            <div class="bg-gray-800/30 rounded-xl p-6 mb-8">
                <div class="space-y-6">
                    {{-- Bank Name --}}
                    @if (!empty($method->bank_name))
                        <div class="flex flex-col sm:flex-row sm:items-center gap-4 p-4 bg-gray-800/50 rounded-lg hover:bg-gray-800/70 transition-colors group">
                            <div class="sm:w-1/3">
                                <div class="flex items-center gap-3">
                                    <i class="fas fa-building w-5 h-5 text-gray-400 group-hover:text-theme-primary transition-colors"></i>
                                    <span class="text-sm text-gray-400">{{ __('t.bank_name') }}</span>
                                </div>
                            </div>
                            <div class="sm:w-2/3 text-lg font-medium text-gray-100">
                                {{ $method->bank_name }}
                            </div>
                        </div>
                    @endif

                    {{-- Account Name --}}
                    @if (!empty($method->account_name))
                        <div class="flex flex-col sm:flex-row sm:items-center gap-4 p-4 bg-gray-800/50 rounded-lg hover:bg-gray-800/70 transition-colors group">
                            <div class="sm:w-1/3">
                                <div class="flex items-center gap-3">
                                    <i class="fas fa-user w-5 h-5 text-gray-400 group-hover:text-theme-primary transition-colors"></i>
                                    <span class="text-sm text-gray-400">{{ __('t.account_name') }}</span>
                                </div>
                            </div>
                            <div class="sm:w-2/3 text-lg font-medium text-gray-100">
                                {{ $method->account_name }}
                            </div>
                        </div>
                    @endif

                    {{-- Account Number --}}
                    @if (!empty($method->account_number))
                        <div class="flex flex-col sm:flex-row sm:items-center gap-4 p-4 bg-gray-800/50 rounded-lg hover:bg-gray-800/70 transition-colors group">
                            <div class="sm:w-1/3">
                                <div class="flex items-center gap-3">
                                    <i class="fas fa-credit-card w-5 h-5 text-gray-400 group-hover:text-theme-primary transition-colors"></i>
                                    <span class="text-sm text-gray-400">{{ __('t.account_number') }}</span>
                                </div>
                            </div>
                            <div class="sm:w-2/3 text-lg font-medium text-gray-100 font-mono">
                                {{ $method->account_number }}
                            </div>
                        </div>
                    @endif

                    {{-- Swift Code --}}
                    @if (!empty($method->swift_code))
                        <div class="flex flex-col sm:flex-row sm:items-center gap-4 p-4 bg-gray-800/50 rounded-lg hover:bg-gray-800/70 transition-colors group">
                            <div class="sm:w-1/3">
                                <div class="flex items-center gap-3">
                                    <i class="fas fa-hashtag w-5 h-5 text-gray-400 group-hover:text-theme-primary transition-colors"></i>
                                    <span class="text-sm text-gray-400">{{ __('t.swift_code') }}</span>
                                </div>
                            </div>
                            <div class="sm:w-2/3 text-lg font-medium text-gray-100 font-mono">
                                {{ $method->swift_code }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            @include('millage.deposit.includes.submit-payment')
        </div>
    @endif

    {{-- Credit Card & Other Payment Methods --}}
    <div class="max-w-2xl mx-auto">
        @if ($method->name == 'Credit-Debit Card')
            <div class="space-y-6">
                {{-- Payment Provider Selection --}}
                <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                    @if ($settings->credit_card_provider == 'Paystack')
                        <div class="bg-gray-800/30 p-6 rounded-xl">
                            @include('millage.deposit.includes.paystack-payment')
                        </div>
                    @endif

                    @if ($settings->credit_card_provider == 'Flutterwave')
                        <div class="bg-gray-800/30 p-6 rounded-xl">
                            @include('millage.deposit.includes.flutterwave-payment')
                        </div>
                    @endif

                    @if ($settings->credit_card_provider == 'Stripe')
                        <div class="bg-gray-800/30 p-6 rounded-xl">
                            @include('millage.deposit.includes.stripe-payment')
                        </div>
                    @endif
                </div>
            </div>
        @endif

        {{-- PayPal Payment --}}
        @if ($method->name == 'Paypal')
            <div class="bg-gray-800/30 p-6 rounded-xl">
                @include('millage.deposit.includes.paypal-payment')
            </div>
        @endif
    </div>
</div>



