<div class="space-y-6" x-data="{ sub: false }">
    {{-- Breadcrumbs --}}
    <div class="flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">Dashboard</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <a href="{{ route('user.copier.show') }}" @if($settings->spa_mode) wire:navigate @endif class="text-gray-400 hover:text-gray-100">Copytrade overview</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <a href="{{ route('user.copier.masters') }}" @if($settings->spa_mode) wire:navigate @endif class="text-gray-400 hover:text-gray-100">Providers</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">Provider Information</span>
    </div>

    <x-danger-alert />
    <x-success-alert />

    <div class="grid gap-6" :class="sub ? 'lg:grid-cols-[1fr,400px]' : 'lg:grid-cols-1'">
        <div class="space-y-6">
            @if($provider)
                {{-- Action Button --}}
                <div class="flex justify-end">
                    <button 
                        @click="sub = !sub"
                        :class="sub ? 'bg-red-400/10 text-red-400 hover:bg-red-400/20' : 'bg-theme-primary text-black hover:bg-theme-primary-dark'"
                        class="px-4 py-2 rounded-lg transition-colors">
                        <span x-text="sub ? 'Cancel' : 'Copy from this account'"></span>
                    </button>
                </div>

                {{-- Provider Details --}}
                <div class="bg-theme-secondary rounded-xl p-6 space-y-6">
                    <div class="grid lg:grid-cols-2 gap-6">
                        <div class="space-y-3">
                            <div>
                                <span class="text-gray-400">Account:</span>
                                <span class="font-medium">{{ $provider['account_name'] }}</span>
                            </div>
                            <div>
                                <span class="text-gray-400">Account ID:</span>
                                <span class="font-medium">{{ $provider['login'] }}</span>
                            </div>
                            <div>
                                <span class="text-gray-400">Account Platform:</span>
                                <span class="font-medium">{{ $provider['platform'] }}</span>
                            </div>
                        </div>

                        <div class="space-y-3">
                            <div>
                                <span class="text-gray-400">Currency:</span>
                                <span class="font-medium">{{ $provider['currency'] }}</span>
                            </div>
                            <div>
                                <span class="text-gray-400">Leverage:</span>
                                <span class="font-medium">{{ $provider['leverage'] }}</span>
                            </div>
                            <div>
                                <span class="text-gray-400">Server:</span>
                                <span class="font-medium">{{ $provider['server'] }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="border-t border-gray-800 pt-6">
                        <h5 class="text-theme-primary font-medium mb-4">Account Strategy</h5>
                        <div class="space-y-4">
                            <div>
                                <h6 class="text-gray-400 mb-1">Strategy Name:</h6>
                                <p>{{ $provider['strategy_name'] }}</p>
                            </div>
                            <div>
                                <h6 class="text-gray-400 mb-1">Description:</h6>
                                <p>{{ $provider['strategy_description'] }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Account Metrics --}}
                @if($provider['show_stats'] === 1)
                    <div>
                        <h5 class="text-lg font-medium mb-4">Account Metrics</h5>
                        <livewire:user.copy-trade.metrics :id="$provider['id']" lazy />
                    </div>
                @endif

            @else
                <div class="bg-theme-secondary rounded-xl p-12 text-center">
                    <i data-lucide="alert-circle" class="w-12 h-12 text-gray-400 mx-auto mb-4"></i>
                    <h5 class="text-lg font-medium">No Data Available</h5>
                    <p class="text-gray-400 mt-2">We could not retrieve any data for this provider account</p>
                </div>
            @endif
        </div>

        {{-- Subscription Form --}}
        <div x-show="sub" x-transition>
            <div class="bg-theme-secondary rounded-xl p-6">
                <h4 class="text-lg font-medium mb-6">Add new account</h4>
                <form wire:submit='addAccount' class="space-y-6">
                    <div class="grid grid-cols-2 gap-6">
                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">Duration</label>
                            <select wire:model.live="duration" 
                                class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                                <option>Monthly</option>
                                <option>Quarterly</option>
                                <option>Yearly</option>
                            </select>
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">Amount({{ $settings->currency }})</label>
                            <input type="text" wire:model="amount" readonly
                                class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 text-gray-400">
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">Platform</label>
                            <select wire:model="platform"
                                class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                                <option>MT4</option>
                                <option>MT5</option>
                            </select>
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">Login</label>
                            <input type="text" wire:model="login" required
                                class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">Account Password</label>
                            <input type="password" wire:model="password" required
                                class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">Account Name</label>
                            <input type="text" wire:model="name" required
                                class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">Account Type</label>
                            <input type="text" wire:model="account_type" placeholder="E.g. Standard" required
                                class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">Currency</label>
                            <input type="text" wire:model="currency" placeholder="E.g. USD" required
                                class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">Leverage</label>
                            <input type="text" wire:model="leverage" placeholder="E.g. 1:500" required
                                class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">Server</label>
                            <input type="text" wire:model="server" placeholder="E.g. HantecGlobal-live" required
                                class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                        </div>
                    </div>

                    <p class="text-sm text-gray-400">Amount will be deducted from your account balance.</p>

                    <button type="submit"
                        class="bg-theme-primary text-black px-6 py-2.5 rounded-lg hover:bg-theme-primary-dark transition-colors flex items-center gap-2">
                        <div wire:loading wire:target="addAccount">
                            <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
                        </div>
                        <span>Add account</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    lucide.createIcons();
</script>



