<div class="min-h-screen bg-gray-900 flex items-center justify-center p-4">
    <div class="w-full max-w-2xl">
        <!-- Progress Steps -->
        <div class="flex justify-between items-center mb-12 relative">
            <!-- Progress Line -->
            <div class="absolute top-1/2 left-0 w-full h-1 bg-gray-700 -z-10"></div>
            <div class="absolute top-1/2 left-0 h-1 bg-green-500 transition-all duration-500 -z-10"
                 style="width: {{ ($currentStep - 1) * 25 }}%">
            </div>

            <!-- Step Indicators -->
            @foreach([
                __('t.welcome'),
                __('t.deposit'), 
                __('t.trading'),
                __('t.withdraw'),
                __('t.complete')
            ] as $index => $label)
                @php $stepNumber = $index + 1; @endphp
                <div class="flex flex-col items-center">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center transition-all duration-300
                        {{ $currentStep >= $stepNumber ? 'bg-green-500 text-white' : 'bg-gray-700 text-gray-400' }}">
                        @if($currentStep > $stepNumber)
                            <i class="fas fa-check text-xs"></i>
                        @else
                            {{ $stepNumber }}
                        @endif
                    </div>
                    <span class="text-xs mt-2 {{ $currentStep >= $stepNumber ? 'text-green-500' : 'text-gray-500' }}">
                        {{ $label }}
                    </span>
                </div>
            @endforeach
        </div>

        <!-- Step Content Container -->
        <div class="bg-gray-800 rounded-xl p-8 shadow-xl min-h-[400px] flex items-center justify-center">
            
            <!-- Step 1: Welcome -->
            @if($currentStep === 1)
            <div class="text-center animate-fade-in">
                <div class="w-20 h-20 bg-green-500/20 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-rocket text-green-500 text-2xl"></i>
                </div>
                <h1 class="text-2xl font-bold text-white mb-4">{{ __('t.welcome_to_site') }} {{ $settings->site_name }}!</h1>
                <p class="text-gray-400 mb-8">{{ __('t.your_journey_starts_here') }}</p>
                <button wire:click="nextStep" 
                        class="bg-green-500 text-white font-medium px-8 py-3 rounded-lg hover:bg-green-600 transition-colors">
                    {{ __('t.lets_begin') }}
                </button>
            </div>

            <!-- Step 2: Deposit -->
            @elseif($currentStep === 2)
            <div class="w-full animate-fade-in">
                <h2 class="text-2xl font-bold text-white mb-2">{{ __('t.make_first_deposit') }}</h2>
                <p class="text-gray-400 mb-6">{{ __('t.start_funding_account') }}</p>
                
                <div class="grid grid-cols-3 gap-4 mb-8">
                    <div class="bg-gray-700 rounded-lg p-4 text-center hover:bg-gray-600 transition-colors cursor-pointer">
                        <i class="fab fa-bitcoin text-yellow-500 text-2xl mb-2"></i>
                        <p class="text-sm text-gray-300">{{ __('t.crypto') }}</p>
                    </div>
                    <div class="bg-gray-700 rounded-lg p-4 text-center hover:bg-gray-600 transition-colors cursor-pointer">
                        <i class="fas fa-credit-card text-green-500 text-2xl mb-2"></i>
                        <p class="text-sm text-gray-300">{{ __('t.card') }}</p>
                    </div>
                    <div class="bg-gray-700 rounded-lg p-4 text-center hover:bg-gray-600 transition-colors cursor-pointer">
                        <i class="fas fa-university text-blue-500 text-2xl mb-2"></i>
                        <p class="text-sm text-gray-300">{{ __('t.bank') }}</p>
                    </div>
                </div>
                
                <button wire:click="nextStep" 
                        class="w-full bg-green-500 text-white font-medium py-3 rounded-lg hover:bg-green-600 transition-colors">
                    {{ __('t.continue') }}
                </button>
            </div>

            <!-- Step 3: Trading -->
            @elseif($currentStep === 3)
            <div class="w-full animate-fade-in">
                <h2 class="text-2xl font-bold text-white mb-2">{{ __('t.start_trading') }}</h2>
                <p class="text-gray-400 mb-6">{{ __('t.access_advanced_tools') }}</p>
                
                <div class="space-y-4 mb-8">
                    <div class="bg-gray-700 rounded-lg p-4 flex items-center gap-4 hover:bg-gray-600 transition-colors cursor-pointer">
                        <div class="w-12 h-12 bg-green-500/20 rounded-lg flex items-center justify-center">
                            <i class="fas fa-signal text-green-500"></i>
                        </div>
                        <div>
                            <h3 class="font-medium text-white">{{ __('t.signals') }}</h3>
                            <p class="text-sm text-gray-400">{{ __('t.expert_analysis') }}</p>
                        </div>
                    </div>
                    <div class="bg-gray-700 rounded-lg p-4 flex items-center gap-4 hover:bg-gray-600 transition-colors cursor-pointer">
                        <div class="w-12 h-12 bg-green-500/20 rounded-lg flex items-center justify-center">
                            <i class="fas fa-robot text-green-500"></i>
                        </div>
                        <div>
                            <h3 class="font-medium text-white">{{ __('t.auto_copy') }}</h3>
                            <p class="text-sm text-gray-400">{{ __('t.copy_experts') }}</p>
                        </div>
                    </div>
                </div>
                
                <button wire:click="nextStep" 
                        class="w-full bg-green-500 text-white font-medium py-3 rounded-lg hover:bg-green-600 transition-colors">
                    {{ __('t.continue') }}
                </button>
            </div>

            <!-- Step 4: Withdrawal -->
            @elseif($currentStep === 4)
            <div class="w-full animate-fade-in">
                <h2 class="text-2xl font-bold text-white mb-2">{{ __('t.easy_withdrawals') }}</h2>
                <p class="text-gray-400 mb-6">{{ __('t.fast_secure_withdrawals') }}</p>
                
                <div class="space-y-4 mb-8">
                    <div class="bg-gray-700 rounded-lg p-4 flex items-center justify-between hover:bg-gray-600 transition-colors">
                        <div class="flex items-center gap-3">
                            <i class="fas fa-bolt text-green-500"></i>
                            <span class="text-white">{{ __('t.fast_processing') }}</span>
                        </div>
                        <span class="text-sm text-gray-400">{{ __('t.processing_time') }}</span>
                    </div>
                    <div class="bg-gray-700 rounded-lg p-4 flex items-center justify-between hover:bg-gray-600 transition-colors">
                        <div class="flex items-center gap-3">
                            <i class="fas fa-shield-alt text-green-500"></i>
                            <span class="text-white">{{ __('t.secure_transfer') }}</span>
                        </div>
                        <span class="text-sm text-gray-400">{{ __('t.protected') }}</span>
                    </div>
                </div>
                
                <button wire:click="nextStep" 
                        class="w-full bg-green-500 text-white font-medium py-3 rounded-lg hover:bg-green-600 transition-colors">
                    {{ __('t.continue') }}
                </button>
            </div>

            <!-- Step 5: Complete -->
            @elseif($currentStep === 5)
            <div class="text-center animate-fade-in">
                <div class="w-20 h-20 bg-green-500/20 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-check-circle text-green-500 text-2xl"></i>
                </div>
                <h1 class="text-2xl font-bold text-white mb-4">{{ __('t.youre_all_set') }}</h1>
                <p class="text-gray-400 mb-8">{{ __('t.account_ready') }}</p>
                <button wire:click="finish" 
                        class="bg-green-500 text-white font-medium px-8 py-3 rounded-lg hover:bg-green-600 transition-colors">
                    {{ __('t.go_to_dashboard') }}
                </button>
            </div>
            @endif
        </div>

        <!-- Navigation Buttons -->
        @if($currentStep > 1 && $currentStep < 5)
        <div class="flex justify-between mt-6">
            <button wire:click="previousStep" 
                    class="text-gray-400 hover:text-white transition-colors">
                <i class="fas fa-arrow-left mr-2"></i> {{ __('t.back') }}
            </button>
            <button wire:click="nextStep" 
                    class="text-green-500 hover:text-green-400 transition-colors">
                {{ __('t.next') }} <i class="fas fa-arrow-right ml-2"></i>
            </button>
        </div>
        @endif
    </div>
</div>