<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <script type="text/javascript" src="https://js.stripe.com/v3/"></script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="locale" content="{{ app()->getLocale() }}">
    <meta name="content-language" content="{{ app()->getLocale() }}">
    <title>{{ $settings->site_name }} | {{ $title ?? '' }}@yield('title')</title>
    <link rel="icon" href="{{ asset($settings->favicon) }}" type="image/png" />
    
    <script src="https://cdn.tailwindcss.com"></script>
    
    {{-- Theme Colors Component --}}
    <x-theme-colors />
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/dark.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/pako@2.1.0/dist/pako.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');

        body {
            font-family: 'Inter', sans-serif;
        }

        /* Custom Scrollbar Styling */
        * {
            scrollbar-width: thin;
            /* For Firefox */
            scrollbar-color: var(--color-primary-20) var(--color-tertiary);
            /* Thumb color and track color */
        }

        /* Webkit Browsers (Chrome, Safari, newer versions of Opera) */
        *::-webkit-scrollbar {
            width: 8px;
            /* Thin scrollbar */
        }

        *::-webkit-scrollbar-track {
            background: #1A1428;
            /* Dark background for the track */
            border-radius: 10px;
        }

        *::-webkit-scrollbar-thumb {
            background-color: rgba(47, 230, 222, 0.2);
            /* Teal color with opacity */
            border-radius: 10px;
            border: 2px solid transparent;
            background-clip: content-box;
        }

        *::-webkit-scrollbar-thumb:hover {
            background-color: rgba(47, 230, 222, 0.4);
            /* Slightly more opaque on hover */
        }

        .opacity-0 {
            opacity: 0;
        }

        .opacity-100 {
            opacity: 1;
        }

        .transition-opacity {
            transition-property: opacity;
        }

        .duration-300 {
            transition-duration: 300ms;
        }
    </style>

    @include('layouts.includes.livechat')
    @stack('styles')
    @livewireStyles
</head>

<body class="bg-[#0A0714] text-white min-h-screen">
    @include('layouts.includes.header')

    <div class="flex">
        @include('layouts.includes.sidebar')
        <main class="flex-1 sm:p-4 md:p-6 pb-20 md:pb-6 overflow-hidden">
            @yield('content')
        </main>
    </div>

    @include('layouts.includes.mobile-nav')
    @include('layouts.includes.mobile-sidebar')

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            lucide.createIcons();

            window.locale = '{{ app()->getLocale() }}';
            window.translations = @json(__('investment'));
        });

        function setupDropdown(triggerId, menuId) {
            const trigger = document.getElementById(triggerId);
            const menu = document.getElementById(menuId);

            if (trigger && menu) {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    menu.classList.toggle('hidden');
                });

                document.addEventListener('click', (e) => {
                    if (!menu.contains(e.target)) {
                        menu.classList.add('hidden');
                    }
                });
            }
        }

        setupDropdown('languageDropdown', 'languageMenu');
        setupDropdown('notificationDropdown', 'notificationMenu');
        setupDropdown('userDropdown', 'userMenu');
    </script>
    @livewireScripts
    @stack('scripts')
</body>

</html>





