@props([
    'variant' => 'primary', // primary, secondary, success, warning, error, info
    'size' => 'md', // sm, md, lg, xl
    'type' => 'button',
    'disabled' => false,
    'loading' => false,
    'href' => null
])

@php
$classes = 'inline-flex items-center justify-center font-medium rounded-xl transition-all duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 disabled:opacity-50 disabled:cursor-not-allowed';

// Size classes
$sizeClasses = [
    'sm' => 'px-3 py-1.5 text-sm',
    'md' => 'px-4 py-2.5 text-sm',
    'lg' => 'px-6 py-3 text-base',
    'xl' => 'px-8 py-4 text-lg'
];

// Variant classes using CSS variables
$variantClasses = [
    'primary' => 'bg-primary text-white hover:bg-primary-dark focus:ring-primary-20 shadow-primary',
    'secondary' => 'bg-background-tertiary text-text-secondary hover:bg-background-quaternary focus:ring-primary-20',
    'success' => 'bg-success text-white hover:bg-success-dark focus:ring-success/20',
    'warning' => 'bg-warning text-white hover:bg-warning-dark focus:ring-warning/20',
    'error' => 'bg-error text-white hover:bg-error-dark focus:ring-error/20',
    'info' => 'bg-info text-white hover:bg-info-dark focus:ring-info/20',
    'outline-primary' => 'border-2 border-primary text-primary hover:bg-primary hover:text-white focus:ring-primary-20',
    'ghost-primary' => 'text-primary hover:bg-primary-10 focus:ring-primary-20'
];

$finalClasses = $classes . ' ' . ($sizeClasses[$size] ?? $sizeClasses['md']) . ' ' . ($variantClasses[$variant] ?? $variantClasses['primary']);
@endphp

@if($href)
    <a href="{{ $href }}" {{ $attributes->merge(['class' => $finalClasses]) }}>
        @if($loading)
            <svg class="animate-spin -ml-1 mr-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
            </svg>
        @endif
        {{ $slot }}
    </a>
@else
    <button 
        type="{{ $type }}" 
        {{ $disabled ? 'disabled' : '' }}
        {{ $attributes->merge(['class' => $finalClasses]) }}
    >
        @if($loading)
            <svg class="animate-spin -ml-1 mr-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
            </svg>
        @endif
        {{ $slot }}
    </button>
@endif




