<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UpdateUserStatus
{
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check()) {
            // User is online
            Auth::user()->update([
                'is_online' => true,
                'last_seen' => now()
            ]);

            // Set user as offline after inactivity (2 minutes)
            app('cache')->put('user-is-online-' . Auth::id(), true, now()->addMinutes(2));
        }

        return $next($request);
    }
}