<?php

namespace App\Http\Integrations\GetOnlinetrader\Requests\Membership;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class SingleCourse extends Request
{
    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::GET;

    public function __construct(
        protected string $courseId,
    ) {
    }

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return '/course';
    }

    protected function defaultQuery(): array
    {
        return [
            'courseId' => $this->courseId,
        ];
    }
}
